<?xml version="1.0"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
<xsl:output method="html" encoding="utf-8"/>

<xsl:template match="/MEREPORT">
	<html xmlns="http://www.w3.org/1999/xhtml" xml:lang="en" lang="en">
		<head>
			<title>Contacts</title>
			<meta http-equiv="Content-Type" content="text/html; charset=utf-8"/>
			<link rel="stylesheet" type="text/css">
				<xsl:attribute name="href">
					<xsl:value-of select="csspath"/>
				</xsl:attribute>
			</link>
		</head>
		<body>
			<div id="content">		
				<h1>Contacts</h1>
				<xsl:call-template name="contacts"/>
			</div>
		</body>
	</html>
</xsl:template>

<xsl:template name="contacts">
	<table>
		<tr>
			<th>id</th>
			<th>name</th>
			<th>notes</th>
			<th>timesContacted</th>
			<th>lastTimeContacted</th>
			<th>starred</th>
			<th>primaryPhone</th>
			<th>primaryOrganization</th>
			<th>primaryEmail</th>
			<th>customRingtone</th>
			<th>phoneticName</th>
			<th>photo</th>
			<th>phone</th>
			<th>organization</th>
			<th>extension</th>
			<th>contactMethod</th>
			<th>group</th>
		</tr>
		
		<xsl:for-each select="contact">
			<tr>
				<xsl:attribute name="class">
					<xsl:if test="position() mod 2 = 0">zebra1</xsl:if>
					<xsl:if test="position() mod 2 = 1">zebra2</xsl:if>
				</xsl:attribute>	
						
				<td><xsl:value-of select="@id"/></td>
				<td>
					<xsl:if test="not( @name = 'name not provided' )">
						<xsl:value-of select="@name"/>
					</xsl:if>
				</td>
				<td><xsl:value-of select="@notes"/></td>
				<td><xsl:value-of select="@timesContacted"/></td>
				<td><xsl:value-of select="@lastTimeContacted"/></td>
				<td><xsl:value-of select="@starred"/></td>
				<td><xsl:value-of select="@primaryPhone"/></td>
				<td><xsl:value-of select="@primaryOrganization"/></td>
				<td><xsl:value-of select="@primaryEmail"/></td>
				<td><xsl:value-of select="@customRingtone"/></td>
				<td><xsl:value-of select="@phoneticName"/></td>
				<td>
					<xsl:if test="count( photo ) > 0">
						<xsl:call-template name="photos"/>
					</xsl:if>
				</td>
				<td>
					<xsl:if test="count( phone ) > 0">
						<xsl:call-template name="phones"/>
					</xsl:if>
				</td>
				<td>
					<xsl:if test="count( organization ) > 0">
						<xsl:call-template name="organizations"/>
					</xsl:if>
				</td>
				<td>
					<xsl:if test="count( extension ) > 0">
						<xsl:call-template name="extensions"/>
					</xsl:if>
				</td>
				<td>
					<xsl:if test="count( contactMethod ) > 0">
						<xsl:call-template name="contactMethods"/>
					</xsl:if>
				</td>
				<td>
					<xsl:if test="count( group ) > 0">
						<xsl:call-template name="groups"/>
					</xsl:if>
				</td>
			</tr>
		</xsl:for-each>
		
	</table>
</xsl:template>

<xsl:template name="photos">
	<table>
		<tr>
			<th>id</th>
			<th>localpath</th>
		</tr>
		
		<xsl:for-each select="photo">
			<tr>
				<xsl:attribute name="class">
					<xsl:if test="position() mod 2 = 0">zebra1</xsl:if>
					<xsl:if test="position() mod 2 = 1">zebra2</xsl:if>
				</xsl:attribute>	
						
				<td><xsl:value-of select="@id"/></td>
				<td><xsl:value-of select="localpath"/></td>
			</tr>
		</xsl:for-each>
		
	</table>
</xsl:template>

<xsl:template name="phones">
	<table>
		<tr>
			<th>id</th>
			<th>number</th>
			<th>numberKey</th>
			<th>type</th>
			<th>primary</th>
			<th>label</th>
		</tr>
		
		<xsl:for-each select="phone">
			<tr>
				<xsl:attribute name="class">
					<xsl:if test="position() mod 2 = 0">zebra1</xsl:if>
					<xsl:if test="position() mod 2 = 1">zebra2</xsl:if>
				</xsl:attribute>	
						
				<td><xsl:value-of select="@id"/></td>
				<td><xsl:value-of select="@number"/></td>
				<td><xsl:value-of select="@numberKey"/></td>
				<td><xsl:value-of select="@type"/></td>
				<td><xsl:value-of select="@primary"/></td>
				<td><xsl:value-of select="label"/></td>
			</tr>
		</xsl:for-each>
		
	</table>
</xsl:template>

<xsl:template name="organizations">
	<table>
		<tr>
			<th>id</th>
			<th>company</th>
			<th>title</th>
			<th>primary</th>
			<th>type</th>
			<th>label</th>
		</tr>
		
		<xsl:for-each select="organization">
			<tr>
				<xsl:attribute name="class">
					<xsl:if test="position() mod 2 = 0">zebra1</xsl:if>
					<xsl:if test="position() mod 2 = 1">zebra2</xsl:if>
				</xsl:attribute>	
						
				<td><xsl:value-of select="@id"/></td>
				<td><xsl:value-of select="@company"/></td>
				<td><xsl:value-of select="@title"/></td>
				<td><xsl:value-of select="@primary"/></td>
				<td><xsl:value-of select="@type"/></td>
				<td><xsl:value-of select="@label"/></td>
			</tr>
		</xsl:for-each>
		
	</table>
</xsl:template>

<xsl:template name="extensions">
	<table>
		<tr>
			<th>id</th>
			<th>name</th>
			<th>value</th>
		</tr>
		
		<xsl:for-each select="extension">
			<tr>
				<xsl:attribute name="class">
					<xsl:if test="position() mod 2 = 0">zebra1</xsl:if>
					<xsl:if test="position() mod 2 = 1">zebra2</xsl:if>
				</xsl:attribute>	
						
				<td><xsl:value-of select="@id"/></td>
				<td><xsl:value-of select="@name"/></td>
				<td><xsl:value-of select="@value"/></td>
			</tr>
		</xsl:for-each>
		
	</table>
</xsl:template>

<xsl:template name="contactMethods">
	<table>
		<tr>
			<th>id</th>
			<th>kind</th>
			<th>primary</th>
			<th>type</th>
			<th>label</th>
			<th>data</th>
			<th>data_aux</th>
		</tr>
		
		<xsl:for-each select="contactMethod">
			<tr>
				<xsl:attribute name="class">
					<xsl:if test="position() mod 2 = 0">zebra1</xsl:if>
					<xsl:if test="position() mod 2 = 1">zebra2</xsl:if>
				</xsl:attribute>	
						
				<td><xsl:value-of select="@id"/></td>
				<td><xsl:value-of select="@kind"/></td>
				<td><xsl:value-of select="@primary"/></td>
				<td><xsl:value-of select="@type"/></td>
				<td><xsl:value-of select="@label"/></td>
				<td><xsl:value-of select="data"/></td>
				<td><xsl:value-of select="data_aux"/></td>
			</tr>
		</xsl:for-each>
		
	</table>
</xsl:template>

<xsl:template name="groups">
	<table>
		<tr>
			<th>groupId</th>
		</tr>
		
		<xsl:for-each select="group">
			<tr>
				<xsl:attribute name="class">
					<xsl:if test="position() mod 2 = 0">zebra1</xsl:if>
					<xsl:if test="position() mod 2 = 1">zebra2</xsl:if>
				</xsl:attribute>	
						
				<td><xsl:value-of select="text()"/></td>
			</tr>
		</xsl:for-each>
		
	</table>
</xsl:template>

</xsl:stylesheet>

